//: ## ![3DaysOfSwift.com Logo](3DaysIcon46.png) Optional Chaining
//:
//: We can chain commands together on optional types.
//:
//: This results in a cascade of safely unwrapping optionals, returning `nil` for the first `nil` found within the cascade.
//:
//: -------------------
//:


// optional?.optional?.optional?.propertyOrFunction


//:
//: -------------------
//:
//: ## Task:
//:
//: Execute the code below and witness the runtime error.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


class Post {
    var childPost: Post?
    var liked: Bool = false
}
class SocialMediaFeed {
    func likeButtonPressed(forPost post: Post?) {
        // TODO: refactor the code below to use a optional chaining
        post!.liked = true // 💣
    }
}

let feed = SocialMediaFeed()
let currentPost: Post? = nil // let's pretend the post is still loading
feed.likeButtonPressed(forPost: currentPost)


//:
//: -------------------
//:
//: ## Task:
//:
//: In the code above, replace the exclamation mark (`!`) with a question mark (`?`). This is optional chaining.
//:
//: Re-execute the code. No runtime errors occur because the post was safely unwrapped and `nil` was found.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


func likeButtonPressed(forPost post: Post?) {
    // post is replaced by nil when no value exists
    post?.liked = true // safely accessing the liked property
}


//:
//: -------------------
//:
//: With optional chaining we can safely use dot notation to access a property or function.
//:
//: -------------------
//:


let post: Post? = nil
post?.liked = true // safely use dot notation to access a property or function.


//:
//: -------------------
//:
//: Optional chaining is when we add a question mark after the variable. 
//:
//: This safely unwraps the value replacing the chain with `nil` when no value is found.
//:
//: -------------------
//:


// the first occurance of nil terminates the chain replacing the whole chain with nil
post?.childPost?.childPost?.childPost?.childPost?.liked = true


//:
//: -------------------
//:
//: ## Task:
//:
//: Using optional chaining, finish the code below to access the students reading list, then retrieve the first book and finally the about text.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


struct Book {
    let about: String?
    
    init(about: String?) {
        self.about = about
    }
}
struct Student {
    let readingList: [Book]?
    init(readingList: [Book]? = nil) {
        self.readingList = readingList
    }
}

let readingList: [Book]? = [
    Book(about: "description of the story and context of the book"),
    Book(about: "description of the story and context of the book"),
    Book(about: "description of the story and context of the book")
])
let student: Student? = Student(readingList:  readingList)

// TODO: Finish the code below using optional chaining
let bookDescriptionOfFirstBook = // finish this code
print(bookDescriptionOfFirstBook ?? "No desctiption found")

